function y = PV_TSM_fuzzy(x,S,nWin,nHop,Fs)

% Parameters
NFFT = nWin;
win = hann(nWin,'periodic');
nHopA = round(nHop/S);
O_analysis = nWin / nHopA; % analysis overlap factor

% Compute STFT
[X,~] = stft(x,win,nHopA,NFFT);
ola_coef = ola_norm_coef(win,win,nHop);

% Compute transientness
filter_length_t = 200e-3; % in ms
filter_length_f = 500; % in Hz
nMedianH = round(filter_length_t * Fs / nHopA);
nMedianV = round(filter_length_f* NFFT / Fs);
Rt = transientness(X,nMedianH,nMedianV);
transient_threshold = 1e-4;

% Phase vocoder processing
Y = pv_processing(X,nHopA,nHop,Rt,transient_threshold,O_analysis,ola_coef);

% Compute inverse STFT
y = istft(Y,nHop,win,win);
