function Y = pv_processing(X,nHopA,nHopS,Rt,transient_threshold,max_decay_length,ola_coef)

Y = zeros(size(X));
[nBins,nFrames] = size(X);
NFFT = (nBins-1)*2;

% Frame transientness
rt = mean(Rt);
% Time derivative of Rt
rt0 = zeros(size(rt));
rt0(2:end) = rt(1:end-1);
rt_d = (rt-rt0)/nHopA;

% PV variables
k = (0:(nBins-1))';
omega = 2*pi*k/NFFT;

% Transient detection/preservation variables
attack_detected = 0;
decay_detected = 0;
decay_bins = logical(zeros(nBins,1));
decay_gains = ones(nBins,1);
decay_length = 0;
attack_bins = logical(zeros(nBins,1));
attack_gains = ones(nBins,1);
bins_to_reset = logical(zeros(nBins,1));
reset_frame = 0;

% Noise coef based on TSM factor
noise_coef = 1/4 * tanh(4*(nHopS/nHopA - 1.5)) + 1;

for n = 1:nFrames
    % Current frame spectrum
    f = X(:,n);
    r = abs(f);
    phi = angle(f);
    % Frame transientness information
    Rt_frame = Rt(:,n);
    % Find spectral peaks
    peak_loc = zeros(nBins,1);
    nPeaks = 0;
    i = 3;
    while i < nBins-1
        if r(i)>r(i-1) && r(i)>r(i-2) && r(i)>r(i+1) && r(i)>r(i+2)
            nPeaks = nPeaks + 1;
            peak_loc(nPeaks) = i;
            i = i+3;
        else
            i = i+1;
        end
    end
    % Phase propagation
    if (n==1) % First frame, use analysis phase
        psi = phi;
    elseif nPeaks > 0 % Phase locking
        for i = 1:nPeaks
            % Find peak phase rotation
            p = peak_loc(i);
            h_phase_incr = princarg(phi(p) - phi0(p) - omega(p)*nHopA);
            inst_freq = omega(p) + h_phase_incr / nHopA;
            p_phase_rotation = princarg(psi(p)+nHopS*inst_freq - phi(p));
            % Find bins around peak
            if nPeaks == 1
                bin_low = 1;
                bin_high = nBins;
            elseif i == 1
                bin_low = 1;
                bin_high = round((peak_loc(i+1)+p)*0.5);
            elseif i == nPeaks
                bin_low = round((peak_loc(i-1)+p)*0.5);
                bin_high = nBins;
            else
                bin_low = round((peak_loc(i-1)+p)*0.5);
                bin_high = round((peak_loc(i+1)+p)*0.5);
            end
            % Rotate phases according to peak rotation
            for j = bin_low:bin_high
                psi(j) = phi(j) + p_phase_rotation;
                % Phase randomization
                Rn = 1 - abs(1-2*Rt_frame(j)); % noisiness
                An = (tanh(4*(Rn-1))+1)*noise_coef;
                phase_noise_value = pi*An*(rand(1,1)-0.5);
                psi(j) = princarg(psi(j) + phase_noise_value);
            end
        end
    else % No peaks found, standard PV processing
        h_phase_incr = princarg(phi - phi0 - nHopA * omega);
        inst_freq = omega + h_phase_incr / nHopA;
        psi = princarg(psi + inst_freq * nHopS);
    end
    % Transient detection
    if decay_detected
        % Remove bins from set transient bins during decay
        decay_length = decay_length + 1;
        decay_bins = decay_bins & Rt_frame > 0.5;
        if sum(decay_bins) == 0 || decay_length >= max_decay_length
            decay_detected = 0;
            decay_length = 0;
        else
            decay_gains = 1 - Rt_frame(decay_bins);
        end
    end
    % Find local maxima from transientness
    if n > 2
        if (rt_d(n) <= rt_d(n-1) && rt_d(n-1) > rt_d(n-2)) && ...
                rt_d(n-1) > transient_threshold
            % Transient onset detected
            attack_detected = 1;
            decay_bins(:) = 0;
            decay_detected = 0;
        end
    end
    if attack_detected
        % Check for transient center
        if rt_d(n) <= 0 && rt_d(n-1) > 0
            reset_frame = n;
            attack_bins(:) = 0;
            attack_detected = 0;
        end
        % Add bins to set of transient bins during onset
        bins_to_reset = bins_to_reset | Rt_frame > 0.5;
        attack_gains = 1 - Rt_frame(attack_bins);
    end
    % Synthesis magnitude spectrum
    r_synth = r;
    % Modify amplitude if transient onset/offset
    if decay_detected
        r_synth(decay_bins) = r_synth(decay_bins) .* decay_gains;
    elseif attack_detected
        r_synth(attack_bins) = r_synth(attack_bins) .* attack_gains;
    end
    % Phase reset
    if reset_frame == n
        decay_detected = 1;
        decay_bins = bins_to_reset;
        decay_gains(:) = 1.0;
        r_synth(bins_to_reset) = r(bins_to_reset) .* ola_coef .* mean(Rt_frame(bins_to_reset));
        psi(bins_to_reset) = phi(bins_to_reset);
        reset_frame = 0;
        bins_to_reset(:) = 0;
    end
    Y(:,n) = r_synth .* exp(1i*psi);
    phi0 = phi;
end