/***
 * midifreq.h
 *
 * Conversion functions from MIDI note number to frequency and back
 * Created by Jussi Pekonen
 ***/

/* Check if we use the code in C++ */
#ifdef __cplusplus
extern "C" {
#endif
	
/* Header identification */
#ifndef _MIDIFREQ_
#define _MIDIFREQ_

/* Required libraries */
#include <math.h>

/**
 * Function that converts a MIDI note number to a frequency
 *
 * @param MIDI The MIDI note number
 * @return The corresponding frequency
 **/
float midifreq(const float MIDI) {
	// The MIDI note number as a frequency
	return 440.0*pow(2.0, (double) (MIDI - 69.0)/12.0);
}
	
/**
 * Function that converts a frequency to a MIDI note number
 *
 * @param freq The frequency
 * @return The corresponding MIDI note number
 **/
float freqmidi(const float freq) {
	// The MIDI note number as a frequency
	return 69.0+12.0*log2f(freq/440.0);
}
	
#endif

#ifdef __cplusplus
}
#endif
