#
# Vector Phase Distortion - formants
#
from numpy import pi,cos
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties
import pylab

f0 = 500.
fs = 44100.
w0 = 2*pi*f0/fs
N = int(fs/f0)
T = f0/fs
P = 1/T
t = arange(0,P)

# -- phase distortion function
def vpd(x,d,v):
	if x < d[0]:		return (v[0]*x)/d[0]
	elif x < d[1]:		return (v[1]-v[0])*(x-d[0])/(d[1]-d[0]) + v[0]
	elif x < d[2]:		return (v[2]-v[1])*(x-d[1])/(d[2]-d[1]) + v[1]
	else:                   return (1-v[2])*(x-d[2])/(1-d[2]) + v[2]

# -- signal generation
def process(d,v):
	y = zeros(len(t))
	x = zeros(len(t))
	phi = 0
	for n in range(0,len(t)):
		x[n] = vpd(phi,d,v)		# vector phase distortion
		phi += T
		if phi > 1: phi -= 1
	y = -cos(2*pi*x)				# waveshaping
	return y,x

# -- spectrum
def spectrum(s):
	NFFT = 16384*2
	NWIN = 16384
	win = chebwin(NWIN, 120)
	win = append(win, zeros(NFFT-NWIN))
	scal = NFFT*sqrt(mean(win**2))
	spec = fft(win*s[0:NFFT])
	mags = sqrt(spec[0:NFFT/2].real**2 + spec[0:NFFT/2].imag**2)
	norm = 20*log10(mags/scal)
	spec = norm - max(norm)
	return spec


# -- main
y1,x1 = process([0.1, 0.5, 0.6], [0.5,0.5,1.0])

# -- plotting
fig = figure(facecolor='#e2e2e2') #, figsize=(10,6))
fontcolor = '#000000'
font = FontProperties(family='serif', size=18)

p1 = subplot(111)
p1.plot(t,y1, 'k', lw=2)
p1.plot(t,x1, 'k--', lw=1)
#p1.plot(arange(0,P+P/50,P/50),0.5*ones((P+1)/(P/50)+1), 'k-', markersize=3)
#p1.plot(arange(0,P+P/50,P/50),0.5*ones((P+1)/(P/50)+1), 'k+', markersize=3)
"""marker,stem,base = pylab.stem(0.5,0.5, linefmt='white', markerfmt='ko')
setp(marker, 'markerfacecolor', 'None')
setp(marker, 'markersize', 9)
setp(base, 'color', 'k')"""
p1.plot(0.5*P,0.5, 's', markersize=8, mfc='None', mew=2)
p1.plot(0.1*P,0.5, 's', markersize=8, mfc='None', mew=2)
p1.plot(0.6*P,1., 's', markersize=8, mfc='None', mew=2)
grid(True)
xlim(0,N)
ylim(-1.1,1.1)

labels = p1.get_xticklabels() + p1.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
p1.xaxis.set_ticks([0,0.5*P,P]) # ,1.5*P,2*P])
p1.xaxis.set_ticklabels(["0","0.5","1"]) # ,"1.5","2"])
xlabel('Time (periods)', color=fontcolor, fontproperties=font)
ylabel('Level', color=fontcolor, fontproperties=font)

fig.subplots_adjust(left=0.16,bottom=0.13,right=0.95)
# fig.subplots_adjust(left=0.13,bottom=0.13,right=0.96,top=0.96,wspace=0.29,hspace=0.39)

show()
