function [p]=wppoles(impresp,PNUM,lambda,WPLENGTH);

% WPPOLES - Pole set generation for the PARFILTDES function based on a warped IIR design.
%   [P]=wppoles(IMPRESP,PNUM,LAMBDA,WPLENGTH) designs a warped IIR filter of the
%   order PNUM for the impulse response IMPRESP with the warping parameter
%   LAMBDA. Then it finds the poles and maps them back to linear frequency
%   resolution. The poles are given in vector P and can be directly used by
%   the PARFILTDES command. The WPLENGTH parameter sets the length of the warped
%   impulse response which is ised for the PRONY method (when omitted, WPLENGTH 
%   is set to 1000). In general, WPLENGHTH > 2 * PNUM as a minimum, but higher values 
%   lead to better fit and slower filter design. This function uses the WARP_IMPRES
%   command from the Warping Toolbox (http://www.acoustics.hut.fi/software/warp/).
%
%   More details can be found in the paper
%   Balazs Bank, "Direct Design of Parallel Second-order Filters for
%   Instrument Body Modeling", International Computer Music Conference,
%   Copenhagen, Denmark, Aug. 2007.
%
%   http://www.acoustics.hut.fi/go/icmc07-parfilt
%
%   C. Balazs Bank, Helsinki University of Technology, June 2007.

if nargin<4,
    WPLENGTH=1000;
end;

impresp_wp = warp_impres(impresp,lambda,WPLENGTH); %warping the impulse response
[Bwp,Awp]=prony(impresp_wp,PNUM,PNUM); %IIR filter design in the warped domain

pwp=roots(Awp); %finding the poles in the warped domain
p=(pwp+lambda)./(1+lambda.*pwp); %unwarping the poles

