function [B,A] = param_peak_boost(f_c,G,Q,fs,plots)
% [B,A] = param_peak_boost(f_c,G,Q,fs,plots);
% Designs 2nd order HP filter after Zlzer: Digital Audio Signal Processing -95
% f_c   = corner frequency [Hz]
% G     = Gain [dB]
% Q     = bandwidth as the Q-factor
% fs    = sampling freq
% plots = if one plots response
% Example: [B,A] = param_peak_boost(1000,20,5,22050,1);
% Coeffs according to Zlzer: Digital Audio Signal Processing -95 pp. 124-125
% Created by H. Penttinen 28.2.2006
if nargin == 4
    plots = 0;
end
V0 = 10^(G/20);
omega_c = 2*pi*f_c;
T = 1/fs;
K = tan(omega_c*T/2);
b0 = (1+(V0/Q)*K+K^2)/((1+(1/Q)*K+K^2));
b1 = 2*(K^2-1)/((1+(1/Q)*K+K^2));
b2 = (1-(V0/Q)*K+K^2)/((1+(1/Q)*K+K^2));
a1 = 2*(K^2-1)/((1+(1/Q)*K+K^2));
a2 = ((1-(1/Q)*K+K^2))/((1+(1/Q)*K+K^2));
B = [b0 b1 b2];
A = [1 a1 a2];
if plots
    figure;freqz(B,A,2^14,fs);
end