%% batchProcessingTest.m
%
% This script processes a pink-noise segment with varying amount of band
% filters in order to detemine the required processing time
%
% M.Antonelli & J.Liski, 04/22

clear
clc;
close all;
format long g;
rng(0)


nt = 10;
[y,Fs] = audioread('pink.wav');
% y = y(1:10*Fs);
for i = 1:31
    gains_t = zeros(31,1);
    gains_t(1:i) = 3;
    
    param = initSGEQ(gains_t); % Initialize GEQ parameters
    [gopt] = ssge3_gains(gains_t,param); % Optimize the gains
    [nums,dens,~] = design_sparse_band_filters(gopt,param); % Design the band filters

    inds = find(abs(gopt)>1e-8);
    if not(isempty(inds))
        nums1 = nums(:, inds);
        dens1 = dens(:, inds);
    else
        nums1 = nums(:, 1);
        dens1 = dens(:, 1);
    end
    

    nsec(i) = numel(inds);
    fprintf('Number of sections in filter cascade: %d\n', nsec(i));
    labs{i} = ['n sec. ',num2str(nsec(i))];
    

    param = initGEQ('sge3'); % Initialize GEQ parameters
    [g, err2] = sge3_gains(gains_t,param); % Optimize the gains
    [nums2,dens2,G0] = design_band_filters(g,param); % Design the band filters
    
    for j = 1:nt
        SOSFilterObj1 = dsp.BiquadFilter('SOSMatrixSource','Input port','ScaleValuesInputPort',false);
        SOSFilterObj2 = dsp.BiquadFilter('SOSMatrixSource','Input port','ScaleValuesInputPort',false);
        tic
        out = step(SOSFilterObj1, y, nums1, dens1(2:3,:));
        t = toc;
        tm1(j,i) = t;
        tic
        out = step(SOSFilterObj2, y, nums2, dens2(2:3,:));
        t = toc;
        tm2(j,i) = t;

    end




end
save('testBatch.mat', 'tm1', 'tm2', 'labs', 'nsec')

%% Plot the results, i.e., Fig. 1

load('testBatch.mat', 'tm1', 'tm2', 'labs', 'nsec')


allComb = unique(nsec);
aveTime = mean(tm1, 1);
for k = 1:length(allComb)
    uniqTime(k) = mean(aveTime(nsec==allComb(k)));
end

figure(2); subplot(1.6,1,1)
plot(allComb,uniqTime,'ro','MarkerSize',8,'MarkerFaceColor','r')
hold on
plot(1:31, ones(1,31)*mean(mean(tm2, 1)),'k','LineWidth',2)
xticks(1:31)
xticklabels({'1',' ','3',' ','5',' ','7',' ','9',' ','11',' ','13',' ','15',' ', ...
    '17',' ','19',' ','21',' ','23',' ','25',' ','27',' ','29',' ','31'})
ax = gca;
ax.FontName = 'Times';
ax.TickLabelInterpreter='latex';
ax.FontSize = 16;
%xticklabels(s)
%xtickangle(0)
xlabel('Active bands')
ylabel('Mean processing time (s)')
xlim([0 32])
%set(gcf, 'Position', get(0, 'Screensize'));
%print(figure(2),'-dpdf','batch','-r0','-painters')

