function [nums,dens,G0] = design_sparse_band_filters(g,param)
% design_sparse_band_filters.m
%
% Design the band filters for the symmetric graphic equalizer
% presented in "Sparse Graphic Equalizer Design" by M. Antonelli, J. Liski, and 
% V. Valimaki in IEEE SPL (2022).
% 
% Input parameters:
% g = optimized filter gains in dB
% param = struct containing fixed design parameters for GEQ
% 
% Output:
% num = numerator coefficients for each filter
% den = denominator coefficients for each filter
% G0 = direct gain
%
% Uses peq.m
%
% Created by Mario Antonelli, Moricone, Roma, Italia, 28 March 2022
% for the
% Acoustics Laboratory
% Dept. of Signal Processing and Acoustics
% Aalto University


M = length(g); % Number of EQ filters
G = 10.^(g/20); % Convert to linear gain factors
gw = param.c.*g; % Gain at bandwidth wg
GB = 10.^(gw/20); % Convert to linear gain factor
% GB = 10^(gw*gopt(inds(i))/20);
% Design filters with optimized gains
nums = zeros(3,M);  dens = zeros(3,M); % num & den coefficients for each filters
G0 = 1; % Direct gain
K = param.K;
G1 = param.G1;
wg = param.wg;
vgains = param.vgains;
for i = 1:M
    if abs(g(i))<=1e-8
        continue;
    end
    w0 = wg(i);
    k  = interp1qr(vgains, K(:,i),abs(g(i)));
    g1 = interp1qr(vgains, G1(:,i),abs(g(i)));
    if g(i)<0
        g1 = -db(g1);
        g1 = 10^(g1/20);
    end
    Dw = k*w0;
    [num,den] = peq(1, G(i), GB(i), w0, Dw, g1);
    G0 = G0*num(1);
    nums(:,i) = num/num(1);
    dens(:,i) = den;
end
