% min0norm4PolySet.m - minimize the zero-norm over polyhedral sets
%
% min0norm4PolySet returns the vector y that minimizes sum(abs(y)>0) +
% lambda*xi subject to norm(By-t,inf) <= xi.
% Usage: xopt = min0norm4PolySet(B, t, lambda, W)
%
% Input:
% 
% B = Over-Determined dictionary Matrix
% t = signal
% thr = threshold for reconstruction error
%
% W(optional) = weigths for reconstruction error
%
% Output:
% xopt = dictionary coefficient (the sparse solution)
%
% Uses PredictorCorrectorMehrotra.m
%
% Created by Mario Antonelli, December 15, 2021

function xopt = min0norm4PolySet(B, t, lambda, W)


diagW = diag(W);
[m,n] = size(B);
C = [B zeros(m,n), -diagW;
    -B zeros(m,n), -diagW;
    eye(n), -eye(n), zeros(n,1);
    -eye(n), -eye(n), zeros(n,1);
    zeros(1,n), zeros(1,n), -10];
b = [t;-t; zeros(n,1); zeros(n,1); 0];

f = [zeros(n,1)' ones(n,1)' lambda]';
A = [C -C eye(2*n+2*m+1)];

c = [f; -f; zeros(2*n+2*m+1,1)];
param_in.verbose = 0;
param_in.eps = 1.e-8;

[~, z, ] = PredictorCorrectorMehrotra(A, b, c, param_in);

p = 2*n+1;
xopt = z(1:p)-z(1+p:2*p);
xopt = xopt(1:n);
xopt(abs(xopt)<=1e-8)= 0;
