% third_octave_asparse_symmetric_GEQs.m
%
% Design and plot Sparse GEQs as presented in "Sparse Graphic Equalizer Design"
% by M. Antonelli, J. Liski, and V. Valimaki in IEEE SPL (2022).
%
% Uses initGEQ.m, sge3_gains.m, design_band_filters, evaluate_and_plot, 
%      initSGEQ.m, ssge3_gains.m, design_sparse_band_filters
%
% Created by Mario Antonelli, Moricone, Roma, Italia, 28 March 2022
% for the
% Acoustics Laboratory
% Dept. of Signal Processing and Acoustics
% Aalto University

clear
clc;
close all;
format long g;
rng(0)


%% Third-octave GEQ
% Choose your third-octave EQ gains

% gc = 12*(2*rand(31,1)-1); 

% gc = zeros(31,1);
% N = 3;
% gc(1:N) = 12*(-1).^(1:N);

gc = [0;0;0;0;0;0;0;2.02146627075106;0.557886672939210;-0.581354884902415; ...
    -1.00956369198496;-1.02056340633461;-0.453062247383890;0.156931434811470; ...
    0.619067740606911;0.877420720679242;0.190724451120313;-0.184943332922387; ...
    -0.747570338436662;-0.954153548437164;-0.668642202210261;-0.672604981572792; ...
    0.970868909845709;3.38968968503728;2.50155168149157;2.31054398235903; ...
    0.660554191616887;8.91731020299650;0;0;0];



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% SGEQ DESIGN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
optimizeBands = false;
param = initSGEQ(gc,optimizeBands); % Initialize SGEQ parameters
[g, err1] = ssge3_gains(gc,param); % Optimize the gains
[nums,dens,G0] = design_sparse_band_filters(g,param); % Design the band filters
inds = find(abs(g)>1e-8);
nsec = numel(inds);
fprintf('\nLP-design (SSGE3)\nNumber of active bands: %d\n', nsec);
fprintf('maximum absolute error: %g\n', err1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evaluate_and_plot(gc,nums,dens,G0,param); % Evaluate and plot the SGEQ frequency response
title('Third-octave Sparse GEQ, LP-design (SSGE3)')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% GEQ DESIGN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
param = initGEQ('sge3'); % Initialize GEQ parameters
[g, err2] = sge3_gains(gc,param); % Optimize the gains
[nums,dens,G0] = design_band_filters(g,param); % Design the band filters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

evaluate_and_plot(gc,nums,dens,G0,param); % Evaluate and plot the GEQ frequency response
title('Third-octave GEQ, WLS-design (SGE3)')
inds = find(abs(g)>1e-8);
nsec = numel(inds);
fprintf('\nWLS-design (SGE3)\nNumber of active bands: %d\n', nsec);
fprintf('maximum absolute error: %g\n', err2);