function S = fbam_magspect(s,NFFT)
%
    % -- windowing
    M = NFFT;
    w = chebwin(M, 120);
    % w = hann(M, 'periodic');
    s = s(1:NFFT) .* [w' zeros(1,NFFT-M)];
 
    % -- magnitude spectrum
    S = 2*abs(fft(s,NFFT));
    S = S(1:length(S)/2);
    S = 20*log10(S);
    S = S - max(S);
end