function fbam_plotspect(s)
%
    N = 65536;  % 2^16;
    f = 0:2/N:1-2/N;
    fmax = 44100/2;

    S = fbam_magspect(s, N);
    h = plot(f, S(1:N/2), 'k', 'LineWidth', 1);
    axis([0 fmax/fmax -100 5])
    grid on
              
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    set(gca, 'YTick', [-100:20:0])
    set(gca, 'XTick', [0:5000/fmax:1])
    set(gca, 'XTickLabel', {'0','5','10','15','20'})
    
    xlabel('Frequency (kHz)')
    ylabel('Magnitude (dB)')
end