function fig03_fbam_filter()
% fig 3 -- FBAM filter reconstruction
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 441;
    w0 = 2*pi*f0/fs;
    P0 = floor(fs/f0);
    dur = 0.2;
    
    t = 0:dur*fs-1;
    a = cos(w0*t);              % time variant coefficients
    x = a;                      % input

    beta = 1.0;

    % -- straight fbam
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
    end
    
    % -- FIR coefficients
    function bk = b(k,n)
        bk = 1;
        for m = 1:k
            bk = bk * beta * cos(w0*(n-m+1));
       end
    end
   
    % -- recursive part
    N = P0;
    aN = prod(beta * a(2:N));

    % -- equivalent filter
    pltv = zeros(size(t));
    for n = 0:length(t)-1
       xz = 0;
       for k = 1:N
          if (n-k) >= 0
             xz = xz + b(k,n) * x(n-k+1);
          end
       end
       if (n-N) > 0,  yz = aN * pltv(n-N);
       else,          yz = 0;    end
       pltv(n+1) = x(n+1) + xz + yz;
    end
   
    % -- scaling
    fbam = fbam / max(abs(fbam));
    pltv = pltv / max(abs(pltv));

    % -- plotting
    figure;
    subplot(1,1,1);
    fbam_plotsig(t,pltv,5*P0);
    title('Fig 3 -- FBAM filter reconstruction')
    hold on;
    plot(t, fbam, 'k.', 'MarkerSize', 7);
    set(gca, 'YTick', [-0.2:0.2:1])
    set(gca, 'Position', [0.13,0.58,0.78,0.34])
    ylim([-0.2,1.1]);

end