function fig04_fbam_ampm()
% fig 4 -- FBAM reconstruction using am/pm
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 441;
    w0 = 2*pi*f0/fs;
    N = floor(fs/f0);
    L = 6*N;
    dur = L+N;
    
    t = 1:dur;
    a = cos(w0*t);              % time variant coefficients
    x = a;                      % input

    beta = 1.0;

    % -- straight FBAM
    fbam = zeros(length(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
    end
    
    % -- coefficients
    function [h2D,gN] = coeffs(a)
        % -- numerator
        h2D = ones(1,L);
        h2D = vertcat(h2D, beta*a(N:L+N-1));
        for i = 3:N-1
            h2D = vertcat(h2D, beta*a(N-i:L+N-1-i).*h2D(i-1,:));
        end
        % -- denominator
        gN = prod(beta*a(1:N));
    end

    % -- frequency response of the filter
    function H = freq_resp(n,w0,h2D,gN)
        num = 0;
        for i = 1:size(h2D,1)
            h = h2D(i,:);
            num = num + h(n) * exp(-j*w0*i);
        end
        den = (1.*exp(-j*w0*0) - gN*exp(-j*w0*N));
        H = num./den;
    end

    % -- get frequency response
    [h2D,gN] = coeffs(a);
    fr_mags = zeros(L,1);
    fr_phas = zeros(L,1);
    for n = 1:L
        fres = freq_resp(n,w0,h2D,gN);
        fr_mags(n) = abs(fres);
        fr_phas(n) = angle(fres);
    end
    
    % -- AM+PM reconstruction
    ampm = fr_mags.*cos(w0*t(1:L)' + fr_phas);
    
    % -- scaling
    fbam = fbam / max(abs(fbam));
    ampm = ampm / max(abs(ampm));

    % -- plotting
    figure;
    subplot(1,1,1);
    L = 5*N;
    fbam_plotsig(t(1:L),ampm(3:L+2),L);
    title('Fig 4 -- FBAM reconstruction using am/pm')
    hold on;
    plot(t, fbam, 'k.', 'MarkerSize', 7);
    set(gca, 'YTick', [-0.2:0.2:1])
    set(gca, 'Position', [0.13,0.58,0.78,0.34])
    ylim([-0.2,1.1]);
end