function fig06_fbam_betasweep()
% fig 6 -- FBAM beta sweep
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    w0 = 2*pi*f0/fs;
    dur = 2;

    t = 0:dur*fs-1;
    a = cos(w0*t);      % time variant coefficients
    x = a;              % input
    
    L  = 1.5*fs;
    beta  = 0;          % beta
    dB = 1.5/L;         % beta increment

    % -- straight fbam
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
        if beta < 1.5
            beta = beta + dB;
        end
    end
    
    % -- plotting (-96 dB)
    figure('Position',[100 100 800 400])
    sg = subplot(1,1,1);
    [A,f,t] = specgram(fbam, 16384, fs, 2048);
    % title('Fig 6 -- FBAM beta sweep')
    bmin = max(max(abs(A))) / power(10,96/20);
    imagesc(t, f, 20*log10( max(abs(A),bmin)/bmin ))
    pos = get(sg, 'Position');
    pos(3) = pos(3) * 0.9;
    pos(2) = pos(2) * 1.2;
    set(sg, 'Position', pos);

    axis xy;
    axis([0, 1.5, 0, 10000]);
    grid on
    
    % -- greyscale colormap
    lgrays = zeros(100,3);
    for i=1:100
        lgrays(i,:) = 1 - (i/100)^1.0;
    end
    colormap(lgrays);

    % -- labels etc.
    set(gca, 'YTick', [0:2000:10000])
    set(gca, 'XTick', [0:0.2:1.5])
    set(gca, 'YTickLabel', {'0','2','4','6','8','10'});
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)

    % -- colorbar
    c = colorbar;
    set(c, 'YTick', [0:12:96]);
    set(c, 'YTickLabel', {'-96','-84','-72','-60','-48','-36','-24','-12',' 0'});
    set(c ,'FontName', 'times')
    set(c, 'FontSize', 14)
    pos = get(c, 'Position');
    pos(1) = 0.86;
    pos(2) = 0.18;
    pos(3) = 0.02;
    pos(4) = 0.77;
    set(c, 'Position', pos);
    xlabel(c,'dB');

    set(gcf, 'Color', [0.9,0.9,0.9])
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    ylabel('Frequency (kHz)');
    xlabel('\it\beta');
    
end