function fig09_fbam_scaling()
% fig 9 -- FBAM scaling
% - 2D lookup table is created by fbam_scaling.py
%
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%

    % -- cover 88-key piano keyboard
    f1 = 27.5;
    f2 = 4186.01;
    
    % -- 2D lookup table for scaling (generated by fbam_scaling.py)
    function tab = scalingTable()
        tab = importdata('fbam_scale2D.txt', ' ', 0);
    end

    % -- polynomial approximations
    % -- these are used for betas 0..0.95
    % -- for higher betas, see fbam_scaling_gui.py
    function coeffs = scalingCoeffs(fx, maxy, maxbeta, dbeta)
        coeffs = [];
        ib = 1;
        beta = 0.0;
        while beta <= maxbeta
            if beta >= 0.9,         k = 5;
            elseif beta >= 0.8,     k = 3;
            elseif beta >= 0.7,     k = 2;
            else                    k = 1;
            end
            func = polyfit(fx', maxy(:,ib), k);
            func = [zeros(1,6-size(func,2)) func];
            coeffs = vertcat(coeffs, func);
            beta = beta + dbeta;
            ib = ib + 1;
        end
    end

    % -- scaling
    nfreq = 100;            % 100 frequency samples (linear)
    nbeta = 19;             % beta = [0.0,0.95]

    % -- scaling approach #1: 2D lookup table for max values
    c1 = scalingTable();
    
    % -- scaling approach #2: polynomials
    fx = linspace(f1, f2, nfreq);
    zfit = fx;
    % z = (fx-mean(fx))/std(fx);
    % zfit = linspace(z(1),z(end),nfreq);
    coeffs = scalingCoeffs(zfit,c1,0.95,0.05)
    c2 = zeros(nfreq,nbeta);
    for i = 1:nfreq
        for b = 1:nbeta
            c2(i,b) = polyval(coeffs(b,:), zfit(i));
        end
    end

    % -- plotting
    figure('Position',[100 100 800 400])
    subplot(1,1,1);
    for b = 1:2:nbeta
        plot(fx, 20*log10(c1(:,b)/10), 'k', 'LineWidth', 1);
        hold on;
    end
    for b = 1:2:nbeta
        plot(fx(1:2:end), 20*log10(c2(1:2:end,b)/10), 'k.', 'MarkerSize', 7);
        hold on;
    end
    grid on;
    xlim([f1,f2]);
    ylim([-21,1]);
    
    set(gcf, 'Color', [0.9,0.9,0.9])
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    xlabel('Frequency (Hz, 88-key piano range)');
    ylabel('Magnitude (dB)');
    % title('Fig 9 -- FBAM scaling')

end