function fig11_fbam_var1_ffdelay()
% fig 11 -- FBAM variation 1 : feedforward delay
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    w0 = 2*pi*f0/fs;
    P0 = floor(fs/f0);
    dur = 5;

    t = 0:dur*fs-1;
    a = cos(w0*t);              % time variant coefficients
    x = cos(w0*t);              % input
    
    beta = 1;

    % -- variation 1
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n-1) - (x(n) + beta * a(n) * fbam(n-1));
    end
    
    % -- scaling
    fbam = fbam / max(abs(fbam));

    % -- plotting
    figure;
    subplot(2,1,1);
    fbam_plotsig(t,fbam,5*P0);
    title('Fig 11 -- FBAM variation 1 : feedforward delay')
    subplot(2,1,2);
    fbam_plotspect(fbam);
    
end