function fig14_fbam_var3b_heterodyneB()
% fig 14 -- FBAM variation 3a : heterodyning (modulator outside fb loop)
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    w0 = 2*pi*f0/fs;
    P0 = floor(fs/f0);
    dur = 5;

    t = 0:dur*fs-1;
    a = cos(w0*t);          % time variant coefficients
    x = cos(w0*t);          % input
    
    beta = 0.3;
    r = 8;
    rm = cos(r*w0*t);       %ring modulator

    % -- variation 3b
    fbam = zeros(size(t));
    fbam(1) = 0;
    z = 0;
    for n = 2:length(t)
        z = x(n) + beta * a(n) * z;
        fbam(n) = rm(n) * z;
    end
    
    % -- scaling
    fbam = fbam / max(abs(fbam));

    % -- plotting
    figure;
    subplot(2,1,1);
    fbam_plotsig(t,fbam,5*P0);
    title('Fig 14 -- FBAM variation 3a : heterodyning (modulator outside fb loop)')
    subplot(2,1,2);
    fbam_plotspect(fbam);
    
end