function fig17_fbam_var5_delayline()
% fig 17 -- FBAM variation 5 : variable feedback periods
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 441;
    w0 = 2*pi*f0/fs;
    P0 = floor(fs/f0);
    dur = 5;
    NFFT = 65536;

    t = 0:dur*fs-1;
    a = cos(w0*t);      % time variant coefficients
    x = a;              % input
    beta = 0.85;
    D = 100;            % feedback period (in samples)

    % -- init delay line
    d_D = floor(D);
    d_frac = D - floor(D);
    d_buf = zeros(1,44100);
    d_buf(1) = x(1);
    d_n = 1;

    % -- read oldest sample from the delay line
    % -- uses linear interpolation
    function s = getsample()
        s1 = d_buf(d_n);
        i2 = d_n + 1;
        if (i2 > d_D)
            i2 = 1;
        end
        s2 = d_buf(i2);
        s = s1 + d_frac*(s2 - s1);
    end

    % -- write sample to the delay line
    function putsample(s)
        d_buf(d_n) = s;
        d_n = d_n + 1;
        if (d_n > d_D)
            d_n = 1;
        end
    end

    % -- variation 5
    y = zeros(size(t));
    y(1) = 0;
    for n = 2:length(t)
        y(n) = x(n) + beta * a(n) * getsample();
        putsample(y(n));
    end
    y = y / max(abs(y));
    spec1 = fbam_magspect(y, NFFT);
   
    % -- straight fbam
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
    end
    fbam = fbam / max(abs(fbam));

    % -- FBAM spectrum and its spectral envelope
    spec2 = fbam_magspect(fbam, NFFT);
    nharms = floor((fs/2)/f0) + 1;
    sf = zeros(nharms-1);
    sm = zeros(nharms-1);
    f = 0;
    i = 1;
    while f < fs/2
        bin = round((NFFT)*f/fs) + 1;
        sf(i) = 2*f/fs;
        sm(i) = spec2(bin);
        f = f + f0;
        i = i + 1;
    end
    
    % -- waveform plots
    figure;
    subplot(2,1,1);
    plot(t, y, 'k', 'LineWidth', 1);
    hold on;
    plot(t, fbam, 'k--', 'LineWidth', 1);
    grid on;
    xlim([4410,4410+5*P0]);
    ylim([-1.1,1.1]);

    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    set(gca, 'YTick', [-1:0.5:1])
    set(gca, 'XTick', [4410:100:4410+5*P0])
    ylabel('Level')
    xlabel('Time (samples)')
    title('Fig 17 -- FBAM variation 5 : variable feedback periods')
        
    % -- spectrum plots
    subplot(2,1,2);
    f = 0:2/NFFT:1-2/NFFT;
    plot(f, spec1, 'k', 'LineWidth', 1);
    hold on;
    plot(sf,sm, 'k--', 'LineWidth', 1);
    axis([0 1 -100 5])
    grid on
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    xlabel('Frequency (kHz)')
    ylabel('Magnitude (dB)')
    set(gca, 'YTick', [-100:20:0] )
    set(gca, 'XTick', [0:5000/22050:1] )
    set(gca, 'XTickLabel', {'0','5','10','15','20'} )
    
end