function fig21_fbam_ampm_components()
% fig 21 -- FBAM AM/PM components
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 441;
    w0 = 2*pi*f0/fs;
    N = floor(fs/f0);
    L = 6*N;
    dur = L+N;
    
    t = 1:dur;
    a = cos(w0*t);              % time variant coefficients
    x = a;                      % input

    beta = 1.0;

    % -- straight FBAM
    fbam = zeros(length(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
    end
    
    % -- coefficients
    function [h2D,gN] = coeffs(a)
        % -- numerator
        h2D = ones(1,L);
        h2D = vertcat(h2D, beta*a(N:L+N-1));
        for i = 3:N-1
            h2D = vertcat(h2D, beta*a(N-i:L+N-1-i).*h2D(i-1,:));
        end
        % -- denominator
        gN = prod(beta*a(1:N));
    end

    % -- frequency response of the filter
    function H = freq_resp(n,w0,h2D,gN)
        num = 0;
        for i = 1:size(h2D,1)
            h = h2D(i,:);
            num = num + h(n) * exp(-j*w0*i);
        end
        den = (1.*exp(-j*w0*0) - gN*exp(-j*w0*N));
        H = num./den;
    end

    % -- get frequency response
    [h2D,gN] = coeffs(a);
    fr_mags = zeros(L,1);
    fr_phas = zeros(L,1);
    for n = 1:L
        fres = freq_resp(n,w0,h2D,gN);
        fr_mags(n) = abs(fres);
        fr_phas(n) = angle(fres);
    end
    
    % -- generate signals using AM/PM
    am = fr_mags.*cos(w0*t(1:L)');
    pm = cos(w0*t(1:L)' + fr_phas);
    
    % -- scaling
    fbam = fbam / max(abs(fbam));
    am = am / max(abs(am));

    % -- plotting
    figure('Position', [50 200 1100 240])
    axes('Position', [0.1 0.25 0.35 0.7])
    L = 3*N;
    fbam_plotsig(t(1:L),am(3:L+2),L);
    % title('Fig 21a -- FBAM AM reconstruction')
    hold on;
    plot(t, fbam, 'k--', 'LineWidth', 1);
    ylim([-1.1,1.1]);
    
    axes('Position', [0.55 0.25 0.35 0.7])
    L = 3*N;
    fbam_plotsig(t(1:length(pm)),pm,L);
    % title('Fig 21b -- FBAM PM reconstruction')
    hold on;
    plot(t, a, 'k--', 'LineWidth', 1);

end