function fig22_fbam_paf_modfm()
% fig 22 -- FBAM vs. PAF and ModFM
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    w0 = 2*pi*f0/fs;
    N = floor(fs/f0);
    L = 500*N;
    dur = L+N;
    NFFT = 16384;    
    t = 1:dur;

    
    % -- FBAM ------------------------------------------------------------
    wc = w0;
    wm = 1*wc;
    beta = 1.62;
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = cos(wc*t(n)) + beta * cos(wm*t(n)) * fbam(n-1);
    end
    fbam = fbam / max(abs(fbam));

    
    % -- PAF (simple form: wm = n*wc, ws = 0) ----------------------------
    wc = w0;
    wm = 1*wc;
    bw = 0.164;             % corresponds to beta
    g = exp(-wc/bw);
    x = 2*sqrt(g)/(1-g);    % scaling (shaper input)
    z = x.*sin(wm*t/2.);    % scaled half sinusoid
    % waveshaper
    wsz = zeros(length(z),1);
    for n = 1:length(z)
        wsz(n) = 1/(1+z(n)*z(n));
    end
    %
    pg = (1+g)/(1-g);       % scaling (modulator)
    mod = pg * wsz;         % modulator
    paf = mod' .* cos(wc*t);    
    paf = paf / max(paf);

    
    % -- ModFM -----------------------------------------------------------
    wc = w0;
    wm = 1*wc;
    k = 25;                 % corresponds to beta
    rm = exp(k*cos(wm*t)-k);
    modfm = rm .* cos(wc*t);
    
    % -- spectra and spectral envelopes ----------------------------------
    spec1 = fbam_magspect(fbam, NFFT);
    spec2 = fbam_magspect(paf, NFFT);
    spec3 = fbam_magspect(modfm, NFFT);
    nharms = floor((fs/2)/f0) + 1;
    sf = zeros(nharms-1);
    sm1 = zeros(nharms-1);
    sm2 = zeros(nharms-1);
    sm3 = zeros(nharms-1);
    f = 0;
    i = 1;
    while f < fs/2
        bin = round((NFFT)*f/fs) + 1;
        sf(i) = 2*f/fs;
        sm1(i) = spec1(bin);
        sm2(i) = spec2(bin);
        sm3(i) = spec3(bin);
        f = f + f0;
        i = i + 1;
    end


    % -- waveform plots
    % figure;
    % orient landscape 
    % subplot(321)
    figure('Position', [50 200 1100 240])
    axes('Position', [0.1 0.25 0.35 0.7])
    L = 3*N;
    fbam_plotsig(t, paf, L);
    hold on;
    plot(t(1:L),fbam(12:L+11), 'k--', 'LineWidth', 1);
    plot(t, modfm, 'k.');
    ylim([-0.2,1.1]);
    
    % -- spectrum plots
    % subplot(322);
    axes('Position', [0.55 0.25 0.35 0.7])
    f = 0:2/NFFT:1-2/NFFT;
    plot(f, spec2, 'k', 'LineWidth', 1);
    hold on;
    length(sf)
    length(sm1)
    plot(sf(1:24),sm1(1:24), 'k--', 'LineWidth', 1);
    plot(sf(1:24),sm2(1:24), 'k', 'LineWidth', 1);
    plot(sf(1:24),sm3(1:24), 'k.');
    ff = 12000/22100
    axis([0 ff -80 5])
    grid on
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    xlabel('Frequency (kHz)')
    ylabel('Magnitude (dB)')
    set(gca, 'YTick', [-80:20:0] )
    set(gca, 'XTick', [0:ff/6:ff] )
    set(gca, 'XTickLabel', {'0','2','4','6','8','10','12'} )

    % print -deps fig22
end