function fig24_fbam_extended_bw()
% fig 24 -- FBAM bandwidth extension
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    P0 = fs/f0;
    w0 = 2*pi*f0/fs;
    N = floor(fs/f0);
    L = 10000*N;
    NFFT = 65536;    
    dur = 5;
    t = 0:dur*fs-1;
    
    a = cos(w0*t);  % coefficients
    x = a;          % input

    % -- basic FBAM ------------------------------------------------------
    beta = 1.5;
    fbam = zeros(size(t));
    fbam(1) = 0;
    for n = 2:length(t)
        fbam(n) = x(n) + beta * a(n) * fbam(n-1);
    end
    fbam = fbam / max(abs(fbam));

    % -- basic FBAM ------------------------------------------------------
    beta = 5.8;
    fbam_ext = zeros(size(t));
    fbam_ext(1) = 0;
    for n = 2:length(t)
        m = a(n)*a(n)*a(n);
        fbam_ext(n) = x(n) + beta * m * fbam_ext(n-1);
    end
    fbam_ext = fbam_ext / max(abs(fbam_ext));

    % -- spectra and spectral envelopes ----------------------------------
    spec_basic = fbam_magspect(fbam, NFFT);
    spec_extra = fbam_magspect(fbam_ext, NFFT);
    nharms = floor((fs/2)/f0) + 1;
    sf = zeros(nharms-1);
    sm = zeros(nharms-1);
    f = 0;
    i = 1;
    while f < fs/2
        bin = round((NFFT)*f/fs) + 1;
        sf(i) = 2*f/fs;
        sm(i) = spec_basic(bin);
        f = f + f0;
        i = i + 1;
    end

    % -- waveform plots
    figure;
    subplot(2,1,1);
    plot(t, fbam_ext, 'k', 'LineWidth', 1);
    hold on;
    plot(t, fbam, 'k--', 'LineWidth', 1);
    grid on;
    xlim([0,5*P0]);
    ylim([-1.1,1.1]);
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    set(gca, 'YTick', [-1:0.5:1])
    ylabel('Level')
    xlabel('Time (samples)')
    title('Fig 24 -- FBAM bandwidth extension')
    
    % -- spectrum plot
    subplot(2,1,2);
    f = 0:2/NFFT:1-2/NFFT;
    plot(f, spec_extra, 'k', 'LineWidth', 1);
    hold on;
    plot(sf(1:length(sf/2)),sm(1:length(sf/2)), 'k--', 'LineWidth', 1);
    axis([0 1 -100 5])
    grid on;
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    xlabel('Frequency (kHz)')
    ylabel('Magnitude (dB)')
    set(gca, 'YTick', [-100:20:0] )
    set(gca, 'XTick', [0:5000/22050:1] )
    set(gca, 'XTickLabel', {'0','5','10','15','20'} )    

end