function fig26_fbam_abstract_physmod()
% fig 26 -- FBAM abstract physical modeling
% Feedback Amplitude Modulation Synthesis
% J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
% 2010
%
    fs = 44100;
    f0 = 500;
    w0 = 2*pi*f0/fs;
    dur = 2;

    strFile = 'fig26_fbam_abstract_physmod.wav';
    [y,fs,nb] = wavread(strFile);
    dur = length(y);
    y = y / max(abs(y));
    
    % -- plotting (-72 dB)
    figure('Position',[100 100 800 400])
    sg = subplot(1,1,1);
    [A,f,t] = specgram(y, 16384, fs, 2048);
    bmin = max(max(abs(A))) / power(10,72/20);
    imagesc(t, f, 20*log10( max(abs(A),bmin)/bmin ))
    pos = get(sg, 'Position');
    pos(3) = pos(3) * 0.9;    % 1.05
    pos(2) = pos(2) * 1.2;
    set(sg, 'Position', pos);

    axis xy;
    axis([0, 12, 0, 15000]);
    % grid on
    
    % -- greyscale colormap
    lgrays = zeros(100,3);
    for i=1:100
        lgrays(i,:) = 1 - (i/100)^1;
    end
    colormap(lgrays);

    % -- labels etc.
    set(gca, 'YTick', [0:2000:15000])
    set(gca, 'YTickLabel', {'0','2','4','6','8','10','12','14'});

    % -- colorbar
    c = colorbar;
    set(c, 'YTick', [0:12:72]);
    set(c, 'YTickLabel', {'-72','-60','-48','-36','-24','-12',' 0'});
    set(c ,'FontName', 'times')
    set(c, 'FontSize', 14)
    pos = get(c, 'Position');
    pos(1) = 0.86;
    pos(2) = 0.18;
    pos(3) = 0.02;
    pos(4) = 0.77;
    set(c, 'Position', pos);
    xlabel(c,'dB');

    set(gcf, 'Color', [0.9,0.9,0.9])
    set(gca ,'FontName', 'times')
    set(gca, 'FontSize', 14)
    ylabel('Frequency (kHz)');
    xlabel('Time (s)');
    
end