#
# PLTV 2D impulse response
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# v0.1, Jari Kleimola 2010
# (tabs at 3)
#

from numpy import pi,cos,linspace,meshgrid
from scipy.signal import *
import pylab
import mpl_toolkits.mplot3d.axes3d as threed
from matplotlib.collections import PolyCollection

f0 = 4*441.
fs = 44100.
N = int(fs/f0)
L = 5*N
t = arange(0,5,f0/fs)

# coefficients
B = 1.0
a = cos(2*pi*t)

x = a                      # input
y = zeros(len(t))          # output

# -----------------------------------------------------------------------------
# returns h(m,n) matrix
#
def h2D(a):    # a = time variant coefficient vector
   N = len(a)
   h = zeros([N,N], float)
   for m in range(0,N):
      for n in range(0,N):
         if n<0:     h[n,m] = 0
         elif m>n:   h[n,m] = 0
         elif m==n:  h[n,m] = 1 # <-- change to 0 for clarity
         else:       h[n,m] = prod(a[m+1:n+1])     # n+1 because of python
   return h

# -----------------------------------------------------------------------------
# returns h(0,n) vector, in which n goes from 0 to N-1
#
def g1D(a):    # a = time variant coefficient vector (one period)
   N = len(a)  # period
   g = zeros(N)
   g[0] = a[0]
   for n in range(1,N):
      g[n] = a[n]*g[n-1]
   return g

# -----------------------------------------------------------------------------
# sums of IRs
#
def hSum(h):   # h = 2D IR
   N = len(h)
   h_sigma = zeros(N)
   for n in range(0,N):
      for m in range(0,N):
         h_sigma[n] += h[n,m]
   return h_sigma

# -- 2D impulse response
h = h2D(B*a[0:L])
h_sigma = hSum(h[0:L])

# -- straight FBAM
fbam = zeros(len(t))
fbam[0] = x[0]
for n in range(1,len(t)):
   fbam[n] = x[n] + B*a[n]*fbam[n-1]


xs = linspace(0,L,L)
ys = linspace(0,L,L)
X,Y = meshgrid(xs,ys)

fig = pylab.figure()
ax = threed.Axes3D(fig, azim=110, elev=42)
ax.set_xlabel('m')
ax.set_ylabel('n')

ax.plot3D(xs,ys,x[0:len(xs)],color='r',alpha=0.5)
# ax.plot3D(xs,ys,y[0:len(xs)],color='g',alpha=0.75)

verts = []
for i in range(0,len(ys)-1):
   verts.append(zip(xs, h[i]))
poly = PolyCollection(verts)
poly.set_alpha(0.25)
ax.add_collection3d(poly, zs=xs, zdir='y')

ax.set_xlim3d(0, L)
ax.set_ylim3d(0, L)
ax.set_zlim3d(-1, 1)


pylab.show()