#
# fig 3 -- FBAM filter reconstruction
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from numpy import pi,cos
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties

f0 = 441.
fs = 44100.
w0 = 2*pi*f0/fs
N = int(fs/f0)
t = arange(0,5,f0/fs)

a = cos(2*pi*t)   # coefficients
x = cos(2*pi*t)   # input
B = 1             # beta


# -- straight FBAM
fbam = zeros(len(t))
fbam[0] = 0
for n in range(1,len(t)):
   fbam[n] = x[n] + B*a[n]*fbam[n-1]
   
# -- FIR coefficients
def b(k,n):
   bk = 1
   for m in range(1,k+1):
      bk *= B*cos(w0*(n-m+1))
   return bk

# -- recursive part
aN = prod(B*a[1:N+1])

# -- equivalent filter
pltv = zeros(len(t))
for n in range(0,len(t)):
   xz = 0
   for k in range(1,N+1):
      if (n-k) >= 0:
         xz += b(k,n)*x[n-k]
   if (n-N) > 0:  yz = aN*pltv[n-N]
   else:        yz = 0
   pltv[n] = x[n] + xz + yz


# -- plotting
figure(facecolor='#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(1,1,1)
p1.plot(fbam,'r--',lw=2)
p1.plot(pltv,'k:',lw=2)
grid(True)
xlim(0,5*N)

labels = p1.get_xticklabels() + p1.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
xlabel('Time (samples)', color=fontcolor, fontproperties=font)
ylabel('Level', color=fontcolor, fontproperties=font)

suptitle('FBAM filter reconstruction', color=fontcolor, fontsize=10, family='Helvetica')
show()