#
# fig 4 -- FBAM reconstruction using am/pm
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from numpy import pi,cos
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties

f0 = 441.
fs = 44100.
w0 = 2*pi*f0/fs
N = int(fs/f0)
L = 5*N
t = arange(L+N)

a = cos(w0*t)  # coefficients
x = cos(w0*t)  # input
B = 1          # beta


# -- straight FBAM
fbam = zeros(len(t))
fbam[0] = 0
for n in range(1,len(t)):
   fbam[n] = x[n] + B*a[n]*fbam[n-1]
# fbam = fbam / max(abs(fbam))

# -- coefficients
def coeffs(a):
   # -- numerator
   h2D = [ones(L+N)]
   h2D.append(B*a[N:L+N])
   for i in range(2,N):
      h2D.append(B*a[N-i:L+N-i]*h2D[i-1])
   # -- denominator
   gN = prod(B*a[0:N])
   return h2D,gN

# -- frequency response of the filter
def freq_resp(n,w0,h2D,gN):
   num = complex(0.,0.)
   for i in range(0,len(h2D)):
      h = h2D[i]
      num += h[n]*exp(complex(0.,-w0*i))
   den = (1*exp(complex(0.,-w0*0)) - gN*exp(complex(0.,-w0*N)))
   return num/den

# -- get frequency response
h2D,gN = coeffs(a)
fr_mags = zeros(L)
fr_phas = zeros(L)
for n in t[0:L]:
   fres = freq_resp(n,w0,h2D,gN)
   fr_mags[n] = abs(fres)
   fr_phas[n] = arctan2(fres.imag, fres.real)

# -- AM+PM reconstruction
ampm = fr_mags*cos(w0*t[0:L]+fr_phas)
# ampm = ampm / max(ampm)

# -- plotting
figure(facecolor='#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(1,1,1)
p1.plot(fbam,'r--',lw=2)
p1.plot(ampm,'k:',lw=2)
grid(True)
xlim(0,5*N)

labels = p1.get_xticklabels() + p1.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
xlabel('Time (samples)', color=fontcolor, fontproperties=font)
ylabel('Level', color=fontcolor, fontproperties=font)

suptitle('FBAM am/pm reconstruction', color=fontcolor, fontsize=10, family='Helvetica')
show()