#
# fig 6 -- FBAM beta sweep
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from numpy import *
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties

f0 = 500.
fs = 44100.
w0 = 2*pi*f0/fs
P0 = int(fs/f0)
t = arange(0,fs*2)

a = cos(w0*t)  # coefficients
x = cos(w0*t)  # input

L  = 1.5*fs
B  = 0         # beta
dB = 1.5/L     # beta increment


# -- straight FBAM with beta sweep
fbam = zeros(len(t))
fbam[0] = 0
for n in range(1,len(t)):
   fbam[n] = (x[n] + B*a[n]*fbam[n-1])
   if B < 1.5:
      B += dB


# -- plotting
figure(figsize=(12,6),facecolor='#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(111)
specgram(fbam, 2048, Fs=fs, cmap=cm.gist_yarg)
cb = colorbar(ticks=arange(0,-84.1,-12))
clim(-84,0)
xlim(0,1.5)
ylim(0,15000)
grid(True)

labels = p1.get_xticklabels() + p1.get_yticklabels() + cb.ax.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
p1.yaxis.set_ticks(arange(0,15000,2000))
p1.yaxis.set_ticklabels(["","2","4","6","8","10","12","14"])
xlabel(r'$\beta$', color=fontcolor, fontproperties=font, size=16)
ylabel('Frequency (kHz)', color=fontcolor, fontproperties=font, size=12)
cb.set_label('dB')

suptitle('FBAM beta sweep', color=fontcolor, fontsize=10, family='Helvetica')
show()
