#
# fig 14 -- FBAM variation 3b : heterodyning (modulator outside feedback loop)
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from numpy import pi,cos
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties

f0 = 500.
fs = 44100.
w0 = 2*pi*f0/fs
N = int(fs/f0)
t = arange(0,44100*10)

a = cos(w0*t)     # coefficients
x = cos(w0*t)     # input

B = 0.3				# beta
r = 8
rm = cos(r*w0*t)  # ring modulator

# -- variation 3b
fbam = zeros(len(t))
z = 0
for n in range(1,len(t)):
   z = x[n] + B*a[n] * z
   fbam[n] = rm[n] * z
fbam = fbam / max(abs(fbam))

# -- spectrum
NFFT = 16384*2
NWIN = 16384
win = chebwin(NWIN, 120)
win = append(win, zeros(NFFT-NWIN))
scal = NFFT*sqrt(mean(win**2))
spec = fft(win*fbam[0:NFFT])
mags = sqrt(spec[0:NFFT/2].real**2 + spec[0:NFFT/2].imag**2)
norm = 20*log10(mags/scal)
spec = norm - max(norm)

# -- plotting
figure(facecolor='#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(211)
p1.plot(t,fbam,'k',lw=1)
grid(True)
xlim(0,5*N)
ylim(-1.1,1.1)

labels = p1.get_xticklabels() + p1.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
xlabel('Time (samples)', color=fontcolor, fontproperties=font)
ylabel('Level', color=fontcolor, fontproperties=font)

p2 = subplot(212)
p2.plot(linspace(0,fs/2,len(spec)), spec, 'k', lw=1)
grid(True)
xlim(0,fs/2)
ylim(-100,6)

labels = p2.get_xticklabels() + p2.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
# p2.xaxis.set_ticklabels(["0","5","10","15","20"])
xlabel('Frequency (Hz)', color=fontcolor, fontproperties=font)
ylabel('Magnitude (dB)', color=fontcolor, fontproperties=font)

suptitle('FBAM variation 3b: heterodyning (outside)', color=fontcolor, fontsize=10, family='Helvetica')
show()