#
# fig 24 -- FBAM bandwidth extension
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from pylab import *
from scipy import *
from scipy.signal import *
from matplotlib.font_manager import FontProperties

f0 = 500.
fs = 44100.
w0 = 2*pi*f0/fs
N = int(fs/f0)
L = 500*N
t = arange(L+N)

a = cos(w0*t)  # coefficients
x = cos(w0*t)  # input

# -- straight FBAM
B = 1.5  # beta
fbam = zeros(len(t))
fbam[0] = 0
for n in range(1,len(t)):
   fbam[n] = x[n] + B*a[n]*fbam[n-1]
fbam = fbam / max(abs(fbam))

# -- extended bandwidth FBAM
B = 5.8  # beta
fbam_ext = zeros(len(t))
fbam_ext[0] = 0
for n in range(1,len(t)):
   m = a[n]*a[n]*a[n]
   fbam_ext[n] = x[n] + B*m*fbam_ext[n-1]
fbam_ext = fbam_ext / max(abs(fbam_ext))

# -- spectra
NFFT = 16384*2
NWIN = 16384
win = chebwin(NWIN, 120)
win = append(win, zeros(NFFT-NWIN))
scal = NFFT*sqrt(mean(win**2))

spec_fbam = fft(win*fbam[0:NFFT])
mags = sqrt(spec_fbam[0:NFFT/2].real**2 + spec_fbam[0:NFFT/2].imag**2)
norm = 20*log10(mags/scal)
spec_fbam = norm - max(norm)

spec_ext = fft(win*fbam_ext[0:NFFT])
mags = sqrt(spec_ext[0:NFFT/2].real**2 + spec_ext[0:NFFT/2].imag**2)
norm = 20*log10(mags/scal)
spec_ext = norm - max(norm)


# -----------------------------------------------------------------------------
# plotting
# -----------------------------------------------------------------------------

fig = figure(figsize=(11,3), facecolor = '#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(121)
p1.plot(linspace(0,fs/2,len(spec_fbam)), spec_fbam,'k')
grid(True)
xlim(0,fs/2)
ylim(-100,6)

labels = p1.get_xticklabels() + p1.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
xlabel('Frequency (Hz)', color=fontcolor, fontproperties=font)
ylabel('Magnitude (dB)', color=fontcolor, fontproperties=font)

p2 = subplot(122)
p2.plot(linspace(0,fs/2,len(spec_ext)), spec_ext,'k')
grid(True)
xlim(0,fs/2)
ylim(-100,6)

labels = p2.get_xticklabels() + p2.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
# p2.xaxis.set_ticklabels(["0","5","10","15","20"])
xlabel('Frequency (Hz)', color=fontcolor, fontproperties=font)
ylabel('Magnitude (dB)', color=fontcolor, fontproperties=font)

suptitle('FBAM extended bandwidth', color=fontcolor, fontsize=10, family='Helvetica')
subplots_adjust(left=0.07, right=0.97, bottom=0.17)

show()