#
# fig 26 -- FBAM abstract physical modeling
#
# Feedback Amplitude Modulation Synthesis
# J.Kleimola, V.Lazzarini, V.Vlimki, J.Timoney
# 2010
#
from numpy import *
from scipy.signal import *
from pylab import *
from matplotlib.font_manager import FontProperties
from scipy.io import wavfile

fs,y = wavfile.read('fig26_fbam_abstract_physmod.wav')
s = y[:,0] / 32767.

# -- plotting
figure(figsize=(12,6),facecolor='#e2e2e2')
fontcolor = '#222222'
font = FontProperties(family='sans-serif', size=9)

p1 = subplot(111)

specgram(s, 2048, Fs=fs, noverlap=1024, cmap=cm.bone) #cm.gist_yarg)
cb = colorbar(ticks=arange(0,-84.1,-12))
clim(-84,0)
xlim(0,12)
ylim(0,15000) #fs/2)
grid(True)

labels = p1.get_xticklabels() + p1.get_yticklabels() + cb.ax.get_yticklabels()
setp(labels, color=fontcolor, fontproperties=font)
xlabel('Time (s)', color=fontcolor, fontproperties=font, size=12)
ylabel('Frequency (Hz)', color=fontcolor, fontproperties=font, size=12)
cb.set_label('dB')

show()