/*
** oscpack streamlining
**
** J.Kleimola and P.McGlynn, "Streamlining the Flow of Open Sound Control"
** (submitted to SMC-2011)
*/
#include "OscStreamliner.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

namespace osc
{

// ---------------------------------------------------------------------------
// constructors
//
Streamliner::Streamliner()					{ initmap();	 }
Streamliner::Streamliner(char* path)	{ setmap(path); }

// ---------------------------------------------------------------------------
// clear dictionary
//
void Streamliner::initmap()
{
	for (int i=0; i<SL_DICTSIZE; i++)
	{
		dict[i].address[0] = 0;
		dict[i].token = 0;
	}
}

// ---------------------------------------------------------------------------
// read mapping file into the dictionary
//
bool Streamliner::setmap(char* path)
{
	initmap();

	FILE* fp = fopen(path, "r");
	if (!fp) return false;

	int i = 0;
	char str[SL_MAXADDRESS];
	while (fgets(str, sizeof(str), fp) != NULL)
	{
		// -- strip trailing '\n'
		int len = strlen(str)-1;
		if (str[len] == '\n') 
			str[len] = 0;

		// -- tokenize into the dictionary
		char* p = strtok(str, ",");
		while (p)
		{
			dict[i].token = atoi(p);
			p = strtok(NULL, ",");
			if (p)
			{
				strcpy(dict[i].address, p);
				i++;
			}
		}
	}

	fclose(fp);
	return true;
}

// ---------------------------------------------------------------------------
// returns integer representation of the 'address' string, or 0 if not found
// note: improved implementations should use a hashing mechanism
//
int32 Streamliner::iaddress(char* address)
{
	for (int i=0; i<SL_DICTSIZE; i++)
	{
		if (strcmp(address, dict[i].address) == 0)
			return dict[i].token;
	}
	return 0;
}

// ---------------------------------------------------------------------------
// returns string representation of the 'iaddress' token, or 0 if not found
// note: improved implementations should use a hashing mechanism
//
char* Streamliner::address(int32 token)
{
	for (int i=0; i<SL_DICTSIZE; i++)
	{
		if (token == dict[i].token)
			return dict[i].address;
	}
	return 0;
}

} // namespace osc

