/*
** oscpack streamlining
**
** J.Kleimola and P.McGlynn, "Streamlining the Flow of Open Sound Control"
** (submitted to SMC-2011)
*/
#ifndef INCLUDED_OSCSTREAMLINER_H
#define INCLUDED_OSCSTREAMLINER_H

#include "osc/OscTypes.h"

namespace osc
{

#define SL_DICTSIZE		128		// max size of address space
#define SL_MAXADDRESS	128		// max address length

// -- address string - integer token pair
typedef struct
{
	char address[SL_MAXADDRESS];
	int32 token;
} SL_Dict;

class Streamliner
{
public:
	Streamliner();
	Streamliner(char* path);
	bool setmap(char* path);
	int32 iaddress(char* address);
	char* address(int32 token);
protected:
	void initmap();
	SL_Dict dict[SL_DICTSIZE];
};

} // namespace osc
#endif // INCLUDED_OSCSTREAMLINER_H
