/* ===========================================================================
** Streamlined version of SimpleSend.cpp included in the oscpack distribution
**
** For more info, see
** J.Kleimola and P.McGlynn, "Streamlining the Flow of Open Sound Control"
** (submitted to SMC-2011)
** 
*/
#include "osc/OscOutboundPacketStream.h"
#include "osc/OscStreamliner.h"
#include "ip/UdpSocket.h"

#define ADDRESS "127.0.0.1"
#define PORT 8000
#define OUTPUT_BUFFER_SIZE 1024

static osc::Streamliner oscSL("map.txt");

int main(int argc, char* argv[])
{
    UdpTransmitSocket transmitSocket( IpEndpointName( ADDRESS, PORT ) );
    char buffer[OUTPUT_BUFFER_SIZE];
    osc::OutboundPacketStream p( buffer, OUTPUT_BUFFER_SIZE );

	 osc::uint32 token = oscSL.iaddress("/lpf/1/cutoff");
    p << osc::BeginBundleImmediate
        << osc::BeginMessage(token) << (float)0.50
        << osc::EndMessage
        << osc::EndBundle;
    
    transmitSocket.Send( p.Data(), p.Size() );
}

