/* ===========================================================================
** Streamlined version of SimpleReceive.cpp included in the oscpack distribution
**
** For more info, see
** J.Kleimola and P.McGlynn, "Streamlining the Flow of Open Sound Control"
** (submitted to SMC-2011)
** 
*/
#include <iostream>
#include "osc/OscReceivedElements.h"
#include "osc/OscPacketListener.h"
#include "osc/OscStreamliner.h"
#include "ip/UdpSocket.h"

#define PORT 8000

static osc::Streamliner oscSL("map.txt");

class StreamlinedPacketListener : public osc::OscPacketListener
{
protected:
	virtual void ProcessMessage( const osc::ReceivedMessage& m, const IpEndpointName& remoteEndpoint )
	{
		try {
			osc::int32 token = m.AddressAsToken();
			char* address = oscSL.address(token);
			switch (token)
			{
				case 1:
				case 2:
				case 3:
					std::cout << "received: " << token << " (denoting " << address << ")\n";
					break;
				case 4:
				{
					osc::ReceivedMessage::const_iterator arg = m.ArgumentsBegin();
					arg++; // skip the address token
					float param = (arg++)->AsFloat();
					std::cout << "received: " << token << " (denoting " << address << "), parameter: " << param << "\n";
					break;
				}
				default:
					std::cout << "received unknown message: " << token << "\n";
			}

		} catch( osc::Exception& e ) {
			std::cout << "error while parsing message: " << m.AddressPattern() << ": " << e.what() << "\n";
		}
	}
};

int main(int argc, char* argv[])
{
	StreamlinedPacketListener listener;
	UdpListeningReceiveSocket s(
            IpEndpointName( IpEndpointName::ANY_ADDRESS, PORT ),
            &listener );

    std::cout << "press ctrl-c to end\n";
    s.RunUntilSigInt();
    return 0;
}
