# =============================================================================
# Fig4. hardsync
# =============================================================================

from scipy.signal import *
from scipy import *
from pylab import *
import pylab
from matplotlib.font_manager import FontProperties
from scipy.io import wavfile

f0 = 1660.
fs = 44100.
T0 = f0/fs
TB = 2*T0
P0 = fs/f0
P2 = 1/TB

t = arange(0,3*fs)
L = len(t)


# =============================================================================
# support
# =============================================================================

# -- bipolar modulo counter
def phase(L):
	s = zeros(L)
	p = 0
	for n in range(0,L):
		s[n] = p
		p += TB
		if p > 2: p -= 2
	return s

def phase1(L):
	s = zeros(L)
	p = 0
	for n in range(0,L):
		s[n] = p
		p += T0
		if p > 1: p -= 1
	return s

# -- spectrum
def spectrum(s, NFFT=16384*2, NWIN=16384):
	win = chebwin(NWIN, 120)
	win = append(win, zeros(NFFT-NWIN))
	scal = NFFT*sqrt(mean(win**2))
	spec = fft(win*s[0:NFFT])
	mags = sqrt(spec[0:NFFT/2].real**2 + spec[0:NFFT/2].imag**2)
	norm = 20*log10(mags/scal)
	spec = norm - max(norm)
	return spec


# -- trivial
def trivial_hardsync(L,r):
	s = zeros(L)
	p = 0
	m = 0
	TM = T0/r
	for n in range(0,L):
		s[n] = 2*p - 1
		m += TM
		if m > 1:
			m -= 1
			p = 0 # r*m
		else:
			p += T0
			if p > 1:
				p -= 1
	return s

# -- W = 1
def PTR1_hardsync(L,r):
	y = zeros(L)
	TM = T0/r
	s = 0
	m = 0
	reset = 0
	for n in range(0,L):
		if s < T0:
			d = s*P0
			if reset == 1:	h = r - floor(r); reset = 0
			else:				h = 1
			y[n] = 2*s - T0 - 1 - h*(d*2 - 2)
		else: y[n] = 2*s - T0 - 1
		m += TM
		if m > 1:
			m -= 1
			s = r*m
			if (r % 1):
				reset = 1
		else:
			s += T0
			if s > 1:
				s -= 1
	return y

# -- W = 2
def PTR2_hardsync(L,r):
	y = zeros(L)
	TM = T0/r
	T2 = 2*T0
	s = 0
	m = 0
	reset = 0
	for n in range(0,L):
		if s < T0:
			p = s*P0
			if reset == 1:	h = r - floor(r)
			else:				h = 1
			y[n] = 2*s - T2 - 1 - h*(p*p - 2)
		elif s < T2:
			p = s*P0
			if reset == 1:	h = r - floor(r); reset = 0
			else:				h = 1
			y[n] = 2*s - T2 - 1 + h*(p*p - 4*p + 4)
		else: y[n] = 2*s - T2 - 1
		m += TM
		if m > 1:
			m -= 1
			s = r*m
			if (r % 1):
				reset = 1
		else:
			s += T0
			if s > 1:
				s -= 1
	return y

# -- W = 3
def PTR3_hardsync(L,r):
	y = zeros(L)
	TM = T0/r
	T2 = 2*T0
	T3 = 3*T0
	s = 0
	m = 0
	reset = 0
	for n in range(0,L):
		if s < T0:
			p = s*P0
			if reset == 1:	h = r - floor(r)
			else:				h = 1
			y[n] = 2*s - T3 - 1 - h*(p**3/3 - 2)
		elif s < T2:
			p = s*P0
			if reset == 1:	h = r - floor(r)
			else:				h = 1
			y[n] = 2*s - T3 - 1 + h*(2*(p**3)/3 - 3*p*p + 3*p + 1)
		elif s < T3:
			p = s*P0
			if reset == 1:	h = r - floor(r); reset = 0
			else:				h = 1
			y[n] = 2*s - T3 - 1 - h*(p**3/3 - 3*p*p + 9*p - 9)
		else: y[n] = 2*s - T3 - 1
		m += TM
		if (m > 1):
			m -= 1
			if (r % 1) > T3:
				s = r*m
				reset = 1
			else:
				s += T0
				if s > 1:
					s -= 1
		else:
			s += T0
			if s > 1:
				s -= 1
	y[0] = y[1] = y[2] = 0
	return y

# -- spectral envelope
def spectral_envelope(spec,r,NFFT=16384*2):
	sf = []
	sm = []
	f = f0/r
	while f <= fs/2:
		bin = round(f*NFFT/fs)
		sf.append(f)
		sm.append(spec[bin])
		f += f0/r
	return sf,sm


# =============================================================================
# main
# =============================================================================

# -- phase and trivial bipolar saw
phi = phase(L)
phi1 = phase1(L)

# -- signals
r = 1.5
s0 = trivial_hardsync(L,r)
s1 = PTR1_hardsync(L,r)
s2 = PTR2_hardsync(L,r)
s3 = PTR3_hardsync(L,r)

# wavfile.write('trivial.wav', fs, array(s0*32000, dtype='int16') )
# wavfile.write('ptr.wav', fs, array(s3*32000, dtype='int16') )

spec0 = spectrum(s0)
spec1 = spectrum(s1)
spec2 = spectrum(s2)
spec3 = spectrum(s3)
h0_f,h0_m = spectral_envelope(spec0,r,NFFT=16384*2)
h3_f,h3_m = spectral_envelope(spec3,r,NFFT=16384*2)


# -- plotting -----------------------------------------------------------------

fig = figure(facecolor='#e2e2e2', figsize=(10,6))
font = FontProperties(family='Times New Roman', size=21)

def set_plot_props_1(p, marker, stem, base, PP):
	setp(marker, 'markerfacecolor', 'black')
	setp(marker, 'markersize', 8)
	setp(base, 'color', 'black')
	setp(stem, 'alpha','0')
	xlim(0,PP)
	ylim(-1.1,1.1)
	p.xaxis.set_ticks([0,10,20,30,40])
	xlabel('Time (samples)', fontproperties=font)
	# ylabel('Level', fontproperties=font)
	labels = p.get_xticklabels() + p.get_yticklabels()
	setp(labels, fontproperties=font)

def set_plot_props_2(p):
	xlim(0,fs/2)
	ylim(-80,6)
	labels = p.get_xticklabels() + p.get_yticklabels()
	setp(labels, fontproperties=font)
	p.xaxis.set_ticklabels(["0","5","10","15","20"])
	p.yaxis.set_ticks([0,-20,-40,-60,-80])
	xlabel('Frequency (kHz)', fontproperties=font)
	ylabel('Magnitude (dB)', fontproperties=font)


PP = 2.5*P0
ti = arange(0,PP, 1./20)

p1 = subplot(221)
marker,stem,base = pylab.stem(t[0:PP+1], s0[0:PP+1], markerfmt='ko')
yi = stineman_interp(ti, t[0:PP], s0[0:PP], None)
plot(ti, yi, 'k')
set_plot_props_1(p1, marker, stem, base, PP)
text(1.1,0.7, '(a)', fontproperties=font)

p2 = subplot(222)
p2.plot(linspace(0,fs/2,len(spec0)), spec0, 'k', lw=1)
marker,stem,base = pylab.stem(h0_f,h0_m, markerfmt='ko')
setp(marker, 'markerfacecolor', 'None')
setp(marker, 'markersize', 12)
setp(base, 'alpha','0')
setp(stem, 'alpha','0')
set_plot_props_2(p2)
text(19700,-10, '(b)', fontproperties=font)

p3 = subplot(223)
marker,stem,base = pylab.stem(t[0:PP+1], s3[0:PP+1], markerfmt='ko')
ti = arange(0,PP, 1./20)
yi = stineman_interp(ti, t[0:PP], s3[0:PP], None)
plot(ti, yi, 'k')
xlim(0,PP+1)
set_plot_props_1(p3, marker, stem, base, PP)
text(1.1,0.7, '(c)', fontproperties=font)

p4 = subplot(224)
p4.plot(linspace(0,fs/2,len(spec3)), spec3, 'k', lw=1)
p4.plot(h0_f, h0_m, 'k--', lw=1)
marker,stem,base = pylab.stem(h3_f,h3_m, markerfmt='ko')
setp(marker, 'markerfacecolor', 'None')
setp(marker, 'markersize', 12)
setp(base, 'alpha','0')
setp(stem, 'alpha','0')
set_plot_props_2(p4)
text(19700,-10, '(d)', fontproperties=font)

fig.subplots_adjust(left=0.13, bottom=0.12, right=0.99, top=0.9, wspace=0.3, hspace=0.38 )
show()
