from scipy.signal import *
from scipy import *
from pylab import *
import pylab
from matplotlib.font_manager import FontProperties
from scipy.io import wavfile

f0 = 500.
fs = 44100.
T0 = f0/fs
P0 = fs/f0

t = arange(0,3*fs)
L = len(t)
imax = 2**16


# =============================================================================
# SIGNALS
# =============================================================================

# -----------------------------------------------------------------------------
#
def trivial_xor():
	s = zeros(L)
	sd1 = zeros(L)
	sd2 = zeros(L)
	s = zeros(L)
	w = 0.5
	p = 0
	for n in range(0,L):
		d1 = 2*p - 1
		if p < w:	d2 = 0
		else:			d2 = -0.5
		x1 = int(d1 * imax) & 0xFFFF
		x2 = int(d2 * imax) & 0xFFFF
		y = (x1 ^ x2) / float(imax)
		s[n] = 2*y - 1
		sd1[n] = d1
		sd2[n] = d2
		p += T0
		if p > 1: p -= 1
	return s

# -----------------------------------------------------------------------------
#
def trivial_xor_withSources():
	s = zeros(L)
	sd1 = zeros(L)
	sd2 = zeros(L)
	s = zeros(L)
	w = 0.5
	p = 0
	for n in range(0,L):
		d1 = 2*p - 1
		if p < w:	d2 = 0
		else:			d2 = -0.5
		x1 = int(d1 * imax) & 0xFFFF
		x2 = int(d2 * imax) & 0xFFFF
		y = (x1 ^ x2) / float(imax)
		s[n] = 2*y - 1
		sd1[n] = d1
		sd2[n] = d2
		p += T0
		if p > 1: p -= 1
	return s,sd1,sd2

# -----------------------------------------------------------------------------
#
def PTR1_xor():
	s = trivial_xor() - 2*T0
	#
	T1 = 2*T0
	P1 = 1/T1
	cdc = 1 + T1
	p0 = p1 = 0
	#
	for n in range(0,L):
		if p0 < 0.5:
			h = 0.5
			if p1 < T1:
				s[n] = p1*(2 - 2*h*P1) + 2*h - cdc
		elif p0 < 0.75:
			h = 0.5
			if p1 < T1:
				s[n] = p1*(2 - 2*h*P1) + 2*h - cdc + 1
		else:
			h = 1
			pp = p1 - 0.5
			if pp < T1:
				s[n] = pp*(2 - 2*h*P1) + 2*h - cdc
		#
		p0 += T0
		p1 += T1
		if p0 > 1:	p0 -= 1
		if p1 > 1:	p1 -= 1
	return s

# -----------------------------------------------------------------------------
#
def PTR2_xor():
	s = trivial_xor() - 4*T0
	#
	T1 = 2*T0
	P1 = 1/T1
	T2 = 2*T1
	P2 = P1*P1
	cdc = 1 + T2
	p0 = p1 = 0
	#
	for n in range(0,L):
		if p0 < 0.5:
			h = 0.5
			if p1 < T1:
				s[n] = p1*p1*(-h*P2) + p1*(2) + 2*h - cdc
			elif p1 < T2:
				s[n] = p1*p1*(h*P2) + p1*(2-4*h*P1) + 4*h - cdc
		elif p0 < 0.75:
			h = 0.5
			if p1 < T1:
				s[n] = p1*p1*(-h*P2) + p1*(2) + 2*h - cdc + 1
			elif p1 < T2:
				s[n] = p1*p1*(h*P2) + p1*(2-4*h*P1) + 4*h - cdc + 1
		else:
			h = 1
			pp = p1 - 0.5
			if pp < T1:
				s[n] = pp*pp*(-h*P2) + pp*(2) + 2*h - cdc
			elif pp < T2:
				s[n] = pp*pp*(h*P2) + pp*(2-4*h*P1) + 4*h - cdc
		#
		p0 += T0
		p1 += T1
		if p0 > 1:	p0 -= 1
		if p1 > 1:	p1 -= 1
	return s

# -----------------------------------------------------------------------------
#
def PTR3_xor():
	s = trivial_xor() - 6*T0
	#
	T1 = 2*T0
	P1 = 1/T1
	T2 = 2*T1
	P2 = P1*P1
	T3 = 3*T1
	P3 = (P1*P1*P1)/3.
	cdc = 1 + T3
	p0 = p1 = 0
	#
	for n in range(0,L):
		if p0 < 0.5:
			h = 0.5
			if p1 < T1:
				s[n] = p1*p1*p1*(-h*P3) + p1*(2) + 2*h - cdc
			elif p1 < T2:
				s[n] = p1*p1*p1*(2*h*P3) + p1*p1*(-3*h*P2) + p1*(2+3*h*P1) + h - cdc
			elif p1 < T3:
				s[n] = p1*p1*p1*(-h*P3) + p1*p1*(3*h*P2) + p1*(2-9*h*P1) + 9*h - cdc
		elif p0 < 0.75:
			h = 0.5
			if p1 < T1:
				s[n] = p1*p1*p1*(-h*P3) + p1*(2) + 2*h - cdc + 1
			elif p1 < T2:
				s[n] = p1*p1*p1*(2*h*P3) + p1*p1*(-3*h*P2) + p1*(2+3*h*P1) + h - cdc + 1
			elif p1 < T3:
				s[n] = p1*p1*p1*(-h*P3) + p1*p1*(3*h*P2) + p1*(2-9*h*P1) + 9*h - cdc + 1
		else:
			h = 1
			pp = p1 - 0.5
			if pp < T1:
				s[n] = pp*pp*pp*(-h*P3) + pp*(2) + 2*h - cdc
			elif pp < T2:
				s[n] = pp*pp*pp*(2*h*P3) + pp*pp*(-3*h*P2) + pp*(2+3*h*P1) + h - cdc
			elif pp < T3:
				s[n] = pp*pp*pp*(-h*P3) + pp*pp*(3*h*P2) + pp*(2-9*h*P1) + 9*h - cdc
		#
		p0 += T0
		p1 += T1
		if p0 > 1:	p0 -= 1
		if p1 > 1:	p1 -= 1
	return s


# -- spectrum
def spectrum(s, NFFT=16384*2, NWIN=16384):
	win = chebwin(NWIN, 120)
	win = append(win, zeros(NFFT-NWIN))
	scal = NFFT*sqrt(mean(win**2))
	spec = fft(win*s[0:NFFT])
	mags = sqrt(spec[0:NFFT/2].real**2 + spec[0:NFFT/2].imag**2)
	norm = 20*log10(mags/scal)
	spec = norm - max(norm)
	return spec


# =============================================================================
# main
# =============================================================================

s0,o1,o2 = trivial_xor_withSources()
s1 = PTR1_xor()
s2 = PTR2_xor()
s3 = PTR3_xor()

spec0 = spectrum(s0)
spec1 = spectrum(s1)
spec2 = spectrum(s2)
spec3 = spectrum(s3)

wavfile.write('trivial_xor.wav', fs, array(s0*32000, dtype='int16') )
wavfile.write('ptr_xor.wav', fs, array(s3*32000, dtype='int16') )


# -- plotting -----------------------------------------------------------------

fig = figure(facecolor='#e2e2e2', figsize=(10,10))
font = FontProperties(family='Times New Roman', size=16)

def set_plot_props_1(p, label, marker, stem, base, PP):
	if marker:	setp(marker, 'markerfacecolor', 'none')
	if marker:	setp(marker, 'markersize', 8)
	if base:		setp(base, 'color', 'black')
	if stem:		setp(stem, 'alpha','0')
	xlim(0,PP)
	ylim(-1.2,1.2)
	p.xaxis.set_ticks([0,25,50,75,100,125,150,175])
	xlabel('Time (samples)', fontproperties=font)
	ylabel(label, fontproperties=font, rotation=360)
	labels = p.get_xticklabels() + p.get_yticklabels()
	setp(labels, fontproperties=font)

def set_plot_props_2(p):
	xlim(0,fs/2)
	ylim(-80,6)
	labels = p.get_xticklabels() + p.get_yticklabels()
	setp(labels, fontproperties=font)
	p.xaxis.set_ticklabels(["0","5","10","15","20"])
	p.yaxis.set_ticks([0,-20,-40,-60,-80])
	xlabel('Frequency (kHz)', fontproperties=font)
	ylabel('Magnitude (dB)', fontproperties=font)


PP = 2*P0
ti = arange(0,PP, 1./20)

p1 = subplot(421)
p1.plot(o1, 'r')
p1.plot(o2, 'g')
p1.plot(s0, 'k' ,lw='2')
set_plot_props_1(p1, '(a)', None, None, None, PP)
grid()

p2 = subplot(422)
p2.plot(linspace(0,fs/2,len(spec0)), spec0, 'k', lw=1)
set_plot_props_2(p2)

p3 = subplot(423)
# p3.plot(s1, 'k')
marker,stem,base = pylab.stem(t[0:PP+1], s1[0:PP+1], markerfmt='ko')
yi = stineman_interp(ti, t[0:PP], s1[0:PP], None)
p3.plot(ti, yi, 'k')
set_plot_props_1(p3, '(b)', marker, stem, base, PP)

p4 = subplot(424)
p4.plot(linspace(0,fs/2,len(spec1)), spec1, 'k', lw=1)
set_plot_props_2(p4)

p5 = subplot(425)
# p5.plot(s2, 'k')
marker,stem,base = pylab.stem(t[0:PP+1], s2[0:PP+1], markerfmt='ko')
yi = stineman_interp(ti, t[0:PP], s2[0:PP], None)
p5.plot(ti, yi, 'k')
set_plot_props_1(p5, '(c)', marker, stem, base, PP)

p6 = subplot(426)
p6.plot(linspace(0,fs/2,len(spec2)), spec2, 'k', lw=1)
set_plot_props_2(p6)

p7 = subplot(427)
# p7.plot(s3, 'k')
marker,stem,base = pylab.stem(t[0:PP+1], s3[0:PP+1], markerfmt='ko')
yi = stineman_interp(ti, t[0:PP], s3[0:PP], None)
p7.plot(ti, yi, 'k')
set_plot_props_1(p7, '(d)', marker, stem, base, PP)

p8 = subplot(428)
p8.plot(linspace(0,fs/2,len(spec3)), spec3, 'k', lw=1)
set_plot_props_2(p8)

fig.subplots_adjust(left=0.13, bottom=0.12, right=0.99, top=0.9, wspace=0.3, hspace=0.38 )
show()
