function show_reconstruction_results(clean_feas1, feas1, mask1, reconstructed_feas1, method_name1)

% decide plot size

screen_size=get(0,'ScreenSize');
figure('Position',[screen_size(3)/3, screen_size(4)/2, screen_size(3)/3, screen_size(4)/2]);

N1 = size(clean_feas1,2);

% what we have to plot

num_reconstructions = size(reconstructed_feas1,2);
num_plots = num_reconstructions+3;

subplot(num_plots,1,1);
imagesc(clean_feas1);
minmax1=caxis;
title('Clean speech');

subplot(num_reconstructions+3,1,2);
imagesc(feas1);
caxis(minmax1);
title('Clean speech and noise');

fwsnr1 = calculate_fws(exp(feas1),exp(clean_feas1),0.2);

text(N1+10,10,[num2str(fwsnr1,'%.1f') ' dB'])

subplot(num_reconstructions+3,1,3);
imagesc(mask1);
title('Estimated mask');

for index = 1:num_reconstructions
    
subplot(num_plots,1,index+3);
imagesc(reconstructed_feas1{index});
caxis(minmax1);
title(method_name1{index});

fwsnr1 = calculate_fws(exp(reconstructed_feas1{index}),exp(clean_feas1),0.2);

text(N1+10,10,[num2str(fwsnr1,'%.1f') ' dB'])

end

set(findall(gcf,'type','text'),'FontSize',10,'FontWeight','normal');
colormap(flipud(colormap('gray')));

end

% FWSNR

function F1 = calculate_fws(test_feas1,reference_feas1,gamma1)

% normalise feature vectors to unit area

mel_norm_test = bsxfun(@rdivide,test_feas1,sum(test_feas1));
mel_norm_reference = bsxfun(@rdivide,reference_feas1,sum(reference_feas1));

% calculate SNR

S1 = 10*log10(power(mel_norm_reference,2)./power(mel_norm_reference-mel_norm_test,2));
S1 = max(min(S1,35),-10);

W1 = power(mel_norm_reference,gamma1);
F1 = sum(sum(W1.*S1)./sum(W1))/size(mel_norm_reference,2);

end