% This is a simple demo

load('test_data');

% The speech data used in this demo is available: http://www.emime.org/participate/emime-bilingual-database

% 1-3: Finnish speaker FM3
% 4-6: Finnish speaker FF3

file_num = 1; % 1-6

audio_wav = test_data.pink_wav{file_num};

% Load precomputed log-compressed mel-spectral features:

feas1 = test_data.pink_pre{file_num};

% Mask estimation operates in the mel-spectral domain:
    
mask1 = estimate_noise_mask(exp(feas1), audio_wav, test_data.fs, test_data.frame_ms, test_data.step_ms);

% Reconstruction

load('gmm_demo_emime'); % load pre-trained clean speech model

% trained with the GMMBAYES toolbox: http://www.it.lut.fi/project/gmmbayes/

% GMM-MMSE

% Bounded conditional mean imputation with TPMI

reconstructed_feas1{1}=tpmi(feas1, mask1, gmm_model1, 0);

% Bounded conditation mean imputation with TCMI

reconstructed_feas1{2}=tcmi(feas1, mask1, gmm_model1, 0);

% GMM-MAP

if exist('qpc','dir')

% Cluster-based imputation (this is not bounded conditional mean imputation, but a related method)

reconstructed_feas1{3}=mapi(feas1, mask1, gmm_model1, 0);

end

clean_feas1 = test_data.clean_pre{file_num}; % load pre-computed clean speech features for reference

show_reconstruction_results(clean_feas1, feas1, mask1, reconstructed_feas1, {'TPMI','TCMI','Cluster-based imputation'});
