function mask1 = estimate_noise_mask(feas1, audio1, fs, frame_ms, step_ms)

% ESTIMATE_NOISE_MASK computes a simple noise estimate and missing-data mask
%
% Input:
%
% feas1  spectral features (channels x num frames)
%
% Output: 
%
% mask1  missing-data mask (channels x num frames)

% (C) 2014 Ulpu Remes
% MIT license
% For license terms and references, see README.txt

% 1) Noise estimate

if exist('VQVAD','dir')&&exist('voicebox','dir')
    
    % VQVAD (available at http://cs.uef.fi/pages/tkinnu/VQVAD/VQVAD.zip)
    
    [junk, junk, params] = VQVAD;

    % Set frames to match the precalculated features:

    params.frame_len=frame_ms/1000;
    params.frame_shift=step_ms/1000;

    speech_ind1 = VQVAD(audio1, fs, params);
    
    % Calculate a simple noise estimate:

    start_speech=min(find(cumsum(speech_ind1)==1));
    end_speech=min(find(cumsum(speech_ind1)==sum(speech_ind1)));

    noise_estimate1 = mean(feas1(:,[1:start_speech end_speech:size(feas1,2)]),2);

else
    
    % For demo purpose: assume utterances start with non-speech frames
    
    noise_estimate1 = mean(feas1(:,1:10),2);
    
end

% 2) Estimated mask

mask1 = bsxfun(@rdivide,feas1,noise_estimate1)>2;

mask1 = bwareaopen(mask1,5);

end

